#ifndef __IPHEADER_H_
#define __IPHEADER_H_

#include "utils.h"

#pragma pack(push, 1)
struct _ip_header {
			u_char  version_ihl;
			u_char  tos;
			u_short total_length;
			u_short identification;
			u_short frag_info;
			u_char  ttl;
			u_char  protocol;
			u_short checksum;
			u_int   source;
			u_int   dest;
};
#pragma pack(pop)

#define IP_HEADER_SIZE sizeof(_ip_header)

class IPHeader
{
public:
  IPHeader(u_int _dest, u_int _src, u_char _protocol, u_short _data_length) ;
  IPHeader(const u_char *from_data);
  void dump();
  u_short compute_checksum();
  void setMem(u_char *to_data);

  u_char version();
  u_char ihl();
  u_char tos();
  u_short total_length();
  u_short identification();
  u_char flags();
  u_short frag_offset();
  u_char ttl();
  u_char protocol();
  u_short checksum();
  u_int source();
  u_int dest();

private:
  _ip_header data;

  u_short comp_checksum;
  void data2host(void);
  void data2network(void);
};

#endif 